
 
; Safe Alarm

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	


; EEPROM
EEPROM1			equ	H'01'	; preset time sets
EEPROM2			equ	H'02'	; preset entry code
EEPROM3			equ	H'03'	; code length
EEPROM4			equ	H'04'	; alarm duration
; RAM 

STORE1				equ	H'20'	; delay counter	
STORE2				equ	H'21'	; delay counter
STORE3				equ	H'22'	; delay counter
FLASH				equ	H'23'	; LED flash
TIMER				equ	H'24'	; timer 
EXTN				equ	H'25'	; delay extension
REPEAT			equ	H'26' 	; Alarm tone burst repeat
WARBLE			equ	H'27'	; warbling flags
TIMEOUT			equ	H'28'	; code entering timeout period
SEQUENCE			equ	H'29'	; code sequence
CODE_LENGTH		equ	H'2A'	; code length in bits
TEMP1				equ	H'2B'	; code sequence temporary
TEMP2				equ	H'2C'	; code length temporary
PREV_ENTRY		equ	H'2D'	; previous entry flag
ALARM				equ	H'2E'	; alarm duration value
BLINK				equ	H'2F'	; LED Blinker 
TEMP0				equ	H'30'	; temporary to check if EEPROM written


; preset EEPROM
	ORG     2101 		; Address for start of EEPROM is found in (12f675-g.lkr) file
 ; start at second EEPROM location (01)
	DE		D'60'	; Preset time grace period initially set at 60 (15s)
	DE		D'00'	; entry code initially 0
	DE		D'00'	; code length initially 0
	DE		D'120'	; alarm duration 60s
	
; start at memory 0

	org		0			; reset vector
						; interrupt vector '4' (not used)
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'	 		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; delay to allow device verify after programming
; start up delay ~3s
	movlw	D'20'		; delay extension
	movwf 	STORE3
DEL_CONT
	clrwdt
	movlw	H'FF'		; delay routine
	call		DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT

; set inputs/outputs
	movlw	B'00000100'
	movwf	GPIO		; outputs low/high
	
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00010010'	; pullups off except GP1 and 4 
	movwf	WPU

	movlw	B'00001000'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00001111'	; settings (pullups enabled) wdt prescaler/128 (18ms x 128 timeout)
	movwf	OPTION_REG
	movlw	B'00000000'	; 
	movwf	ANSEL		; digital I/O
	bcf		STATUS,RP0; select memory bank 0

; initial conditions
	movlw	B'00010010'	; set GP1 and GP4 high
	movwf	GPIO
	movlw	D'200'			; 200ms delay
	call		DELY
	clrf		PREV_ENTRY	; previous entry flag
	clrf		BLINK			; LED blinker

; set GP1 and GP4 to inputs
	bsf		STATUS,RP0	; select memory bank 1
;
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

	movlw	D'200'			; 200ms delay
	call		 DELY
	movlw	D'200'			; 200ms delay
	call		 DELY
; check if both S1 and S2 switches closed for code entry
	btfsc	GPIO,1
	goto	ALM_DUR
	btfss	GPIO,4
	goto	CK_ENTRY_CODE

; S1 closed
; allow setting of delay period from safe door open to alarm
; sound acknowledgement as the start of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
; wait for S1 open	
; 
WAIT_S1_OP
	btfss	GPIO,1
	goto	WAIT_S1_OP
	movlw	D'200'			; 200ms delay
	call		DELY
; sound acknowledgement as the start of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

	movlw	D'4'				; minimum value
	movwf	EXTN	
	
; delay setting
DELY_ROTATE
	movlw	D'200'			; 200ms delay
	call		 DELY

	btfss	GPIO,1			; if S1 is closed store entry value
	goto	END_DELAY_ENTRY

	btfsc	GPIO,4			; count number of S2 presses or count up at DELY rate
	goto	DELY_ROTATE

; sound acknowledgement for switch press
	movlw	D'25'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
			
	movlw	D'4'			; 1s min
	addwf	EXTN,w
	sublw	D'240'		; restrict to 240
	btfsc	STATUS,C
	goto	MORE_EXTN
	movlw	D'240'		; 60s
	movwf	EXTN
	goto	BYPASS_INC
MORE_EXTN	
	movlw	D'4'			; 1 sec steps
	addwf	EXTN,f

BYPASS_INC
	goto	DELY_ROTATE

END_DELAY_ENTRY
	movlw	D'200'		; 200ms delay
	call		 DELY

	movlw	EEPROM1 	; EEPROM address
	call		EEREAD	; sets EEADR
	movf	EXTN,w
	call		EEWRITE	; store

; sound acknowledgement as the end of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

; wait for S1 to open	
S1_OP
	btfss	GPIO,1		; if S1 is open, exit
	goto	S1_OP

	goto	LOAD_X

ALM_DUR ; alarm duration set
;
	btfsc	GPIO,4	; is S2 closed
	goto	LOAD	; no switches pressed

; allow setting of alarm period 
; S2 closed
; allow setting of delay period from safe door open to alarm
; sound acknowledgement as the start of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
; wait for S2 open	
; 
WAIT_S2_OP
	btfss	GPIO,4
	goto	WAIT_S2_OP
	movlw	D'200'			; 200ms delay
	call		 DELY
; sound acknowledgement as the start of setting
	movlw	D'250'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

	movlw	D'20'			; minimum value 10s
	movwf	ALARM		
; delay setting
ALM_ROTATE
	movlw	D'200'		; 200ms delay
	call		 DELY

	btfss	GPIO,4		; if S2 is closed store entry value
	goto	END_ALARM

	btfsc	GPIO,1		; count number of S1 presses or count up at DELY rate
	goto	ALM_ROTATE

;  sound acknowledgement for switch press
	movlw	D'25'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
	movlw	D'20'			; 10s increments
	addwf	ALARM,w
	sublw	D'240'		; restrict to 240 (2minutes)
	btfsc	STATUS,C
	goto	MORE_ALM
	movlw	D'240'
	movwf	ALARM
	goto	BYPASS_INC_ALM
MORE_ALM	
	movlw	D'20'
	addwf	ALARM,f

BYPASS_INC_ALM
	goto	ALM_ROTATE

END_ALARM
 	movlw	D'200'		; 200ms delay
	call		 DELY

	movlw	EEPROM4 	; EEPROM address
	call		EEREAD	; sets EEADR
	movf	ALARM,w
	call		EEWRITE	; store

; sound acknowledgement as the end of setting
	movlw	D'250'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
; wait for S2 to open	
S2_OP
	btfss	GPIO,4		; if S2 is open, exit
	goto	S2_OP

	goto	LOAD_X


CK_ENTRY_CODE
; setting of entry code
; uses initially S1 and S2 closed wait for acknowledgement chirp then enter S1, S2 sequence.
; timeout of 5s if switch not pressed and so entered code is stored. 

; 
; sound acknowledgement as the start of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

; wait for S1 and S2 open
WAIT_ENTRY
	
	btfss	GPIO,4		; check for closed S2
	goto	WAIT_ENTRY
	btfss	GPIO,1		; S1 closed
	goto	WAIT_ENTRY
	movlw	D'200'		; 200ms delay
	call		 DELY
; S1,S2 open
; sound acknowledgement as the start of setting
	movlw	D'255'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

	movlw	D'200'		; 200ms delay
	call		 DELY

	clrf		SEQUENCE 		; bits 0,1,2,3 have codes bit 7 is for whether code is set
	clrf		CODE_LENGTH	; code length in bits

; set counter for 5s
	movlw	D'50'	
	movwf	TIMEOUT	; delay before timeout

; check for switches
CK_SW
	btfss	GPIO,1		; if S1 is closed set in sequence
	goto	ROTATE_1
	btfss	GPIO,4		; count number of S2 presses
	goto	ROTATE_2

; reduce timeout
	movlw	D'100'		; 100ms delay
	call		 DELY
	decfsz	TIMEOUT,f	; if reaches zero timeout
	goto	CK_SW
; Store values
	movlw	EEPROM2 	; EEPROM address
	call		EEREAD	; sets EEADR
	movf	SEQUENCE,w
	call		EEWRITE	; store
	movlw	EEPROM3 	; EEPROM address
	call		EEREAD	; sets EEADR
	movf	CODE_LENGTH,w
	call		EEWRITE	; store

	goto	LOAD_PRE

ROTATE_1
; set counter for 5s
	movlw	D'50'	
	movwf	TIMEOUT	; delay before timeout
; move code and shift
	bcf		STATUS,C	 ; clear carry (S1 clear bit)
ROLL
	rlf		SEQUENCE,f
	
; each time add 1 to the CODE_LENGTH
	incf		CODE_LENGTH,w
	xorlw	D'8'			; 8-bit maximum
	btfsc	STATUS,Z	; when reached 8-bit then end
	goto	LOAD_PRE
	incf		CODE_LENGTH,f	

; sound acknowledgement for switch press
	movlw	D'25'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
SW_OFF


; wait for switches to open
	btfss	GPIO,1		; if S1 is closed keep looking for open switch
	goto	SW_OFF
	btfss	GPIO,4		; if S2 is closed keep looking for open switch
	goto	SW_OFF
	movlw	D'200'		; 200ms delay
	call		 DELY
	goto	CK_SW
ROTATE_2
; set counter for 5s
	movlw	D'50'	
	movwf	TIMEOUT	; delay before timeout

; move code and shift
	bsf		STATUS,C	 ; set carry (S2 set bit)
	goto	ROLL

LOAD_PRE
; sound acknowledgement at the end of setting
	movlw	D'250'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

LOAD_X ;  wait before start
	movlw	D'250'		; 250ms delay
	call		 DELY
	movlw	D'250'		; 250ms delay
	call		 DELY
	movlw	D'250'		; 250ms delay
	call		 DELY
	movlw	D'250'		; 250ms delay
	call		 DELY

; Load EEPROM stored values
LOAD

; timer extension
	movlw	EEPROM1 		; EEPROM address
	call		EEREAD		; sets EEADR
	movwf	EXTN

	movlw	EEPROM2		; preset entry code
	call		EEREAD
	movwf	SEQUENCE 		;  code value

	movlw	EEPROM3		; code length
	call		EEREAD
	movwf	CODE_LENGTH	; code length in bits

; check LDR for light/darkness
CK_LDR
	bcf		GPIO,2			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfss	GPIO,3
	goto	ALARM_S		; when GPIO is low then in light

STOP
; set GP1 and GP4 to inputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'00000100'
	movwf	GPIO			; LDR off, LEDs off
	
; SLEEP, low power mode

	sleep					; stop operations
	nop
; awakes with watchdog timeout

	goto	CK_LDR		; check LDR level
	
; ________________________________________
; check LDR
CHECK_LDR

	bcf		GPIO,2			; switch on LDR divider
	nop
	nop
	nop						; settling time
; add hysteresis
	bsf		GPIO,2			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,2			; LDR on
	nop
	nop
	btfsc	GPIO,3	
	retlw	H'FF'			; when FF goto	STOP ; when GPIO is low then light
	bsf		GPIO,2			; LDR divider off
	retlw	H'00'			; continue
; ________________________________________________

ALARM_S
	clrf		BLINK
;  sound 
	movlw	D'250'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)

	bsf		GPIO,2			; LDR off
	clrf		TEMP1		; temporary sequence of code entered
	clrf		TEMP2		; temporary code length entered

LOOP_EXTN

; entry delay ~1 -60s. 
	movf	EXTN,w
	movwf 	STORE3			; delay extension

DEL_CONT1

; bypass flashing LEDs if entry code is started 

	movf	TEMP2,w		; code length entered so far
	btfss	STATUS,Z
	goto	FLASH_BY

; flash Door Open LED
; alternate on/off

	btfss	GPIO,0
	goto	SET0
	bcf		GPIO,0
	goto	FLASH_OUT
SET0
	bsf		GPIO,0
FLASH_OUT

; flash Previous entry LED
; check if door was opened previously
	btfss	PREV_ENTRY,0	; if set light LED1
	goto	DELAY_CONT

	incf		BLINK,f			; set on/off for LED1
	btfss	BLINK,0
	goto	SET5
	bcf		GPIO,5
	goto	DELAY_CONT
SET5
	bsf		GPIO,5

FLASH_BY
DELAY_CONT
; check entry code

	btfss	GPIO,1		; count  S1 closures
	goto	ROTATE_S1
	btfss	GPIO,4		; count number of S2 presses
	goto	ROTATE_S2
	goto	SW_ENTERED

ROTATE_S1

; move code and shift
	bcf		STATUS,C	 ; clear carry (S1 clear bit)
ROLL_ENTER
	rlf		TEMP1,f		; sequence temporary register
	
; each time add 1 to the CODE_LENGTH temporary regiser TEMP2
	incf		TEMP2,f	
; sound acknowledgement of switch
	movlw	D'25'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
	movlw	D'230'			; 200ms delay
	call		 DELY


COMPARE
; compare entered
	movf	TEMP1,w
	xorwf	SEQUENCE,w
	btfss	STATUS,Z
	goto	SW_ENTERED_0

	movf	TEMP2,w
	xorwf	CODE_LENGTH,w
	btfss	STATUS,Z
	goto	SW_ENTERED_0
	goto	NO_ALARM

ROTATE_S2

; move code and shift
	bsf		STATUS,C	 ; set carry (S2 set bit)
	goto	ROLL_ENTER
	
SW_ENTERED_0
SW_ENTERED
	movlw	D'230'		; 200ms delay
	call		 DELY
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT1


SOUND_ALM1
; Sound alarm
	bsf		PREV_ENTRY,0	; set previous entry flag

; load alarm duration

	movlw	EEPROM4
	call		EEREAD
	movwf	ALARM

SND ; (Standard alarm)
	movlw	D'3'
	movwf	WARBLE		; for changing modulation
	movlw	D'20'
	movwf	REPEAT
BURST1
	movlw	D'50'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
	movlw	D'10'			;  
	movwf	STORE3
OFF_DEL

; warble from 400Hz to 600Hz
	movf	WARBLE,w
	xorlw	D'13'	; start again at 13
	btfss	STATUS,Z
	goto	OK
	movlw	D'12'
	movwf	WARBLE

OK	movf	WARBLE,w
	incf		WARBLE,f	; next value
	call		DELW
	decfsz	STORE3,f
	goto	OFF_DEL
	decfsz	REPEAT,f
	goto 	BURST1

; Burst Gap
	movlw	D'7'			;  
	movwf	STORE3
GAP2
	movlw	D'70' 
	call		DELAYX
	decfsz	STORE3,f
	goto	GAP2
	
	decfsz	ALARM,f
	
	goto	SND
	goto	ALM_ENDED

NO_ALARM
	clrf		PREV_ENTRY	; previous entry flag cleared 
	bcf		GPIO,5			;' LED off


ALM_ENDED
; check if a switch is pressed indicating a continuance of code entering

	btfss	GPIO,4		;  S2 pressed
	goto	SOUND_ALM1
	btfss	GPIO,1		; S1
	goto	SOUND_ALM1
; check LDR
; wait for darkness
; check LDR for light/darkness

	bcf		GPIO,2			; switch on LDR divider
	clrwdt
	nop
	nop
	nop						; settling time
	btfss	GPIO,3
	goto	ALM_ENDED		; when GPIO is low then in light
	goto	STOP

; *********************************************
; subroutines

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR_S

; set GP1 and GP4 to outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

GENERATOR_RUN
	movlw	B'00000110'
	movwf	GPIO
;	bsf		GPIO,1
;	bcf		GPIO,4
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC1_S
	decfsz	STORE1,f
	goto	DEC1_S
	movlw	B'00010100'
	movwf	GPIO	
;	bcf		GPIO,1
;	bsf		GPIO,4
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC2_S
	decfsz	STORE1,f
	goto	DEC2_S
	decfsz	STORE2,f		; 4kHz burst length
	goto	GENERATOR_RUN


	movlw	B'00010110'		; GP1 and GP4 high
	movwf	GPIO

; set GP1 and GP4 to inputs
	bsf		STATUS,RP0	; select memory bank 1
;
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	return


; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_FLASH
	movlw	D'10'		; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	D'11'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11
	clrwdt
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return


DELY ; 1ms per value in store approxmately

	movwf	STORE1		; STORE1 is number of loops value
LOOP12	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP13
	clrwdt
	decfsz	STORE2,f
	goto	LOOP13
	decfsz	STORE1,f
	goto	LOOP12
	return

DELW
	movwf	STORE1		; STORE1 is number of loops value
LOOP12Z
	movlw	D'1'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP13_W
	clrwdt
	decfsz	STORE2,f
	goto	LOOP13_W
	decfsz	STORE1,f
	goto	LOOP12Z
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 		STATUS,RP0 	;Bank 1
	movwf 	EEADR 			;Address to read
	bsf 		EECON1,RD		;EE Read
	movf 	EEDATA,W 		;Move data to W
	bcf		STATUS,RP0	;Bank 0
	return
; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bsf 		STATUS,RP0 	;Bank 1
AGAIN
	movwf	EEDATA
	movwf	TEMP0
	bsf		EECON1,WREN	;Enable write
	movlw 	H'55'			;Unlock write
	movwf 	EECON2 ;
	movlw 	H'AA' ;
	movwf 	EECON2 ;
	bsf 		EECON1,WR 	;Start the write
	bcf		EECON1,WREN
CK_WR
	clrwdt
	btfsc	EECON1,WR
	goto	CK_WR

	bcf		STATUS,RP0	;Bank 0
	return					; value written 
	
	end
